# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdtype import *
from .sdapiobject import *
from .sdtype import *
from .sdapiobject import *
from .apiexception import APIException

class SDValue(SDAPIObject):
    """
    Base class of all values
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValue
        """
        super(SDValue, self).__init__(APIContext, handle, *args, **kwargs)

    def getType(self) -> Optional[SDType]:
        """
        Get the value type as string

        """
        outType = ctypes.c_void_p()
        _res = self.mAPIContext.SDValue_getType(self.mHandle, ctypes.byref(outType))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outType, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outType.value, ownHandle=True)

